<?php
include_once 'connect.php';
global $db;
if(isset($_POST['func']))
{
    $func = $_POST['func'];
    if(!empty($func))
    {
        switch($func)
        {
            case 'create_user':
                $userName = $_POST['userName'];
                $chatId = $_POST['chatId'];
                $tonCoinBalance = $_POST['tonCoinBalance'];
                $shibCoinBalance = $_POST['shibCoinBalance'];
                $counter = $_POST['counter'];
                $referral_link = $_POST['referral_link'];
                $referId = $_POST['referrerId'];
                $registrationDate = $_POST['registrationDate'];
                createUser($userName,$chatId,$tonCoinBalance,$shibCoinBalance,$counter,$referral_link,$referId,$registrationDate);
                break;
            case 'getUser':
                $chatId = $_POST['chatId'];
                echo getUser($chatId);
                break;
            case 'updateShib':
                $chatId = $_POST['chatId'];
                $shibCoinBalance = $_POST['shibCoinBalance'];
                echo updateShib($chatId, $shibCoinBalance);
                break;
            case 'updateShib_Balance':
                $chatId = $_POST['chatId'];
                $shibCoinBalance = $_POST['shibCoinBalance'];
                $tonCoinBalance = $_POST['tonCoinBalance'];
                echo updateShib_Balance($chatId, $shibCoinBalance, $tonCoinBalance);
                break;
            case 'updateBalance':
                $chatId = $_POST['chatId'];
                $tonCoinBalance = $_POST['tonCoinBalance'];
                echo updateBalance($chatId, $tonCoinBalance);
                break;
            case 'updateFirstname':
                $chatId = $_POST['chatId'];
                $firstname = $_POST['firstname'];
                updateFirstName($chatId,$firstname);
                break;
            case 'deleteUser':
                $chatId = $_POST['chatId'];
                echo deleteUser($chatId);
                break;
            case 'updateReferId':
                $chatId = $_POST['chatId'];
                $referrerId = $_POST['referrerId'];
                echo updateReferId($chatId,$referrerId);
                break;
            case 'getAllUsers':
                echo getAllUsers();
                break;
            case 'updateCounters':
                echo updateCounters();
                break;
            case 'updateWallet':
                $chatId = $_POST['chatId'];
                $walletAddress = $_POST['walletAddress'];
                 updateWallet($chatId,$walletAddress);
                break;
            case 'upgradeMiner':
                $chatId = $_POST['chatId'];
                $rentedMiner = $_POST['rentedMiner'];
                $minerLevel = $_POST['minerLevel'];
                $rentEndDate = $_POST['rentEndDate'];
                $counter = $_POST['counter'];
                $minerSpeed = $_POST['minerSpeed'];
                upgradeMiner($chatId,$rentedMiner,$minerLevel,$rentEndDate,$counter,$minerSpeed);
                break;
            case 'updateWithdrawal':
                $chatId = $_POST['chatId'];
                $tonCoinBalance = $_POST['tonCoinBalance'];
                $lastWithdrawal = $_POST['lastWithdrawal'];
                updateWithdrawal($chatId,$tonCoinBalance,$lastWithdrawal);
                break;
            case 'create_withdrawal':
                $userId = $_POST['userId'];
                $amount = $_POST['amount'];
                $date = $_POST['date'];
                $type = $_POST['type'];
                CreateWithdrawal($userId,$amount,$date,$type);
                break;
            case 'getClaims':
                $userId = $_POST['userId'];
                echo getClaims($userId);
                break;
            case 'create_claims':
                $userId = $_POST['userId'];
                $amount = $_POST['amount'];
                $date = $_POST['date'];
                $type = $_POST['type'];
                CreateClaims($userId,$amount,$date,$type);
                break;
            case 'getWithdrawals':
                $userId = $_POST['userId'];
                echo getWithdrawals($userId);
                break;
            case 'updateTon':
                $chatId = $_POST['chatId'];
                $tonCoinBalance = $_POST['tonCoinBalance'];
                $counter = $_POST['counter'];
                updateTon($chatId,$tonCoinBalance,$counter);
                break;
            case 'atomic_update_Shib':
    $chatId = $_POST['chatId'];
    $shibCoinBalance = $_POST['shibCoinBalance'];

    // لیست تمام تسک‌های احتمالی
    $possibleTasks = ['telegramJoin1', 'telegramJoin2', 'telegramJoin3', 'telegramJoin4', 'telegramJoin5', 'twitter', 'instagram', 'youtube'];

    $task = "";

    // بررسی اینکه کدام تسک فرستاده شده
    foreach ($possibleTasks as $key) {
        if (!empty($_POST[$key])) {
            $task = $key;
            break;
        }
    }

    atomic_update_Shib($chatId, $shibCoinBalance, $task);
    break;

            case 'atomic_update_ton':
                $chatId = $_POST['chatId'];
                $tonCoinBalance = $_POST['tonCoinBalance'];
                $task = $_POST['task'];
                atomic_update_ton($chatId,$tonCoinBalance,$task);
                break;
            case 'checkChannelJoin':
                $type = $_POST['type'];
                checkChannelJoin($type);
                break;
        }
    }
    else{
        echo "null problem";
    }
}
function createUser($userName, $chatId, $tonCoinBalance, $shibCoinBalance, $counter, $referral_link, $referId, $registrationDate)
{
    global $db;

    try {
        $res = $db->prepare("INSERT INTO `miningapp` (`chatId`, `counter`, `firstName`, `walletAddress`, `referId`, `referral_link`, `registrationDate`, `shibCoinBalance`, `tonCoinBalance`,`invitedUsers`,`rentedMiner`,`minerLevel`,`rentEndDate`,`minerSpeed`,`lastWithdrawal`,`telegramJoin`,`twitter`,`instagram`,`youtube`,`invite3`,`invite5`,`invite10`,`invite20`,`invite50`) 
            VALUES (:chatId, :counter, :firstName, :walletAddress, :referId, :referral_link, :registrationDate, :shibCoinBalance, :tonCoinBalance,:invitedUsers,:rentedMiner,:minerLevel,:rentEndDate,:minerSpeed,:lastWithdrawal,:telegramJoin,:twitter,:instagram,:youtube,:invite3,:invite5,:invite10,:invite20,:invite50)");

        $success = $res->execute(array(
            ':chatId' => $chatId,
            ':counter' => $counter,
            ':firstName' => $userName,
            ':walletAddress' => '',
            ':referId' => $referId,
            ':referral_link' => $referral_link,
            ':registrationDate' => $registrationDate,
            ':shibCoinBalance' => $shibCoinBalance,
            ':tonCoinBalance' => $tonCoinBalance,
            ':invitedUsers' => 0,
            ':rentedMiner' => '',
            ':minerLevel' => 0,
            ':rentEndDate' => '',
            ':minerSpeed' => 0,
            ':lastWithdrawal' => '{}',
            ':telegramJoin' => '',
            ':twitter' => '',
            ':instagram' => '',
            ':youtube' => '',
            ':invite3' => 'false',
            ':invite5' => 'false',
            ':invite10' => 'false',
            ':invite20' => 'false',
            ':invite50' => 'false',
        ));

        if ($success) {
            echo "User successfully inserted.";
        } else {
            echo "Failed to insert user.";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
function updateReferral($chatId,$invitedUsers,$tonCoinBalance)
{
    global $db;
    $query1 = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
    $stmt1 = $db->prepare($query1);
    $exist = $stmt1->execute(array(
        ':chatId' => $chatId
        ));
    if($exist)
    {
        $query2 = "UPDATE `miningapp` SET `tonCoinBalance`=:tonCoinBalance,`invitedUsers`=:invitedUsers WHERE `chatId`=:chatId";
        $stmt2 = $db->prepare($query2);
        $success = $stmt2->execute(array(
            ':chatId' => $chatId,
            ':tonCoinBalance' => $tonCoinBalance,
            ':invitedUsers' => $invitedUsers
            ));
        if($success)
        {
            echo "succesfully added referral";
        }
        else{
            echo "Error updateRef: " . implode(', ',$stmt2->errorInfo());
        }
    }
    else{
        echo "not found referral";
    }
}
function getUser($chatId)
{
    global $db;
    $query = "SELECT * FROM miningapp WHERE chatId = :chatId;";
    $stmt = $db->prepare($query);
    $stmt->execute([':chatId' => $chatId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    return json_encode($user,JSON_PRETTY_PRINT) ?: null;
}

function updateShib_Balance($chatId, $shibCoinBalance, $tonCoinBalance)
{
    global $db;
    $query = "UPDATE miningapp SET shibCoinBalance = :shibCoinBalance, tonCoinBalance = :tonCoinBalance WHERE chatId = :chatId;";
    $stmt = $db->prepare($query);
    $success = $stmt->execute([
        ':shibCoinBalance' => $shibCoinBalance,
        ':tonCoinBalance' => $tonCoinBalance,
        ':chatId' => $chatId
    ]);
    if ($success) {
        echo 'Balance updated successfully.';
    } else {
        echo 'Error updating balance: ' . implode(', ', $stmt->errorInfo());
    }
}

function deleteUser($chatId)
{
    global $db;
    $query = "DELETE FROM miningapp WHERE chatId = :chatId;";
    $stmt = $db->prepare($query);
    $success = $stmt->execute([':chatId' => $chatId]);
    if ($success) {
        echo 'User deleted successfully.';
    } else {
        echo 'Error deleting user: ' . implode(', ', $stmt->errorInfo());
    }
}
function updateReferId($chatId,$referrerId)
{
    global $db;
    $query = "UPDATE `miningapp` SET `referId` = :referId WHERE `chatId`=:chatId and (`referId`=:rI or `referId`=:rI2)";
    $stmt = $db->prepare($query);
    $success = $stmt->execute(array(
        ':referId' => $referrerId,
        ':chatId' => $chatId,
        ':rI' => 0,
        ':rI2' => 1
        ));
    if($success)
    {
        $query3 = "SELECT * FROM `miningapp` WHERE `chatId`=:referId";
        $stmt3 = $db->prepare($query3);
        $stmt3->execute(array(
            ':referId' => $referrerId
            ));
        $xp = 0.2;
        foreach($stmt3 as $row3)
        {
            switch($row3['rentedMiner'])
        {
            case 'Free':$xp = 0.2;
            break;
            case 'TON Silver':$xp = 0.3;
            break;
            case 'TON Gold':$xp = 0.6;
            break;
            case 'TON Diamond':$xp = 1.2;
            break;
            case 'TON Platinum':$xp = 2.4;
            break;
            case 'TON VIP':$xp = 4.8;
            break;
            default:$xp = 0.2;
        }
        }
        //echo "ReferID Updated Successfully...";
        $query2 = "UPDATE `miningapp` SET `invitedUsers` =`miningapp`.`invitedUsers`+:number,`tonCoinBalance`=`miningapp`.`tonCoinBalance`+:tonCoinBalance WHERE `chatId`=:referId";
        $stmt2 = $db->prepare($query2);
        $success2 = $stmt2->execute(array(
            ':number'=> 1,
            ':referId' => $referrerId,
            ':tonCoinBalance' => $xp
            ));
        if($success2)
        {
            echo "invitedUser Updated Successfully";
        }
        else{
            echo "Error: " . implode(', ',$stmt2->errorInfo());
        }
    }
    else{
        echo 'Error updating referrerId: ' . implode(', ', $stmt->errorInfo());
    }
}
function updateFirstName($chatId,$firstName)
{
    global $db;
    $query("UPDATE `miningapp` SET `firstName`=:firstName WHERE `chatId`=:chatId");
    $stmt = $db->prepare($query);
    $success = $stmt->execute(array(
        ':firstName' => $firstName,
        ':chatId' => $chatId
        ));
    if($success)
    {
        echo "firstname updated successfully";
    }
    else{
        echo "Error updating firstname: " . implode(', ', $stmt->errorInfo());
    }
}
function getAllUsers()
{
    global $db;
    $query = "SELECT * FROM `miningapp`";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $user = $stmt->fetchAll(PDO::FETCH_ASSOC);
    return json_encode($user,JSON_PRETTY_PRINT) ?: null;
}
function updateCounters()
{
    global $db;
    $incrementAmount = 0;
    $query = "SELECT `chatId`,`counter`,`rentedMiner` FROM `miningapp`";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (empty($users)) {
        return "No matching records found.";
    }
    $updateQuery = "UPDATE `miningapp` SET `counter`=:counter WHERE `chatId`=:chatId";
    $updateStmt = $db->prepare($updateQuery);
    foreach($users as $user)
    {
        $currentCounter = $user['counter'] ?? 0;
        switch($user['rentedMiner'])
        {
            case 'Free':$incrementAmount = 0;
            break;
            case 'TON Silver':$incrementAmount = 0.00013888888;
            break;
            case 'TON Gold':$incrementAmount = 0.00069444444;
            break;
            case 'TON Diamond':$incrementAmount = 0.00416666666;
            break;
            case 'TON Platinum':$incrementAmount = 0.00902777777;
            break;
            case 'TON VIP':$incrementAmount = 0.02083333333;
            break;
            default:$incrementAmount = 0;
        }
        $newCounter = $currentCounter + $incrementAmount;
        $updateStmt->execute(array(
            ':counter' => round($newCounter, 9),
            ':chatId' => $user['chatId']
            ));
    }
    return "Counters updated successfully.";
}
function updateWallet($chatId,$walletAddress)
{
    global $db;
    $query = "UPDATE `miningapp` SET `walletAddress`=:walletAddress WHERE `chatId`=:chatId";
    $stmt = $db->prepare($query);
    $success = $stmt->execute(array(
        ':chatId' => $chatId,
        ':walletAddress' => $walletAddress
        ));
    if($success)
    {
        echo "walletAddress Updated Successfully";
    }
    else{
        echo "Error updating walletAddress " . implode(', ', $stmt->errorInfo());
    }
}
function upgradeMiner($chatId,$rentedMiner,$minerLevel,$rentEndDate,$counter,$minerSpeed)
{
    global $db;
    $query1 = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
    $stmt1 = $db->prepare($query1);
    $exist = $stmt1->execute(array(
        ':chatId' => $chatId
        ));
    $referId = "";
    $user = $stmt1->fetchAll(PDO::FETCH_ASSOC);
    foreach($user as $row)
    {
        $referId = $row['referId'];
    }
    if($exist)
    {
        $query2 = "UPDATE `miningapp` SET `rentedMiner`=:rentedMiner,`minerLevel`=:minerLevel,`rentEndDate`=:rentEndDate,`counter`=:counter,`minerSpeed`=:minerSpeed WHERE `chatId`=:chatId";
        $stmt2 = $db->prepare($query2);
        $success = $stmt2->execute(array(
            ':rentedMiner' => $rentedMiner,
            ':minerLevel' => $minerLevel,
            ':rentEndDate' => $rentEndDate,
            ':counter' => $counter,
            ':minerSpeed' => $minerSpeed,
            ':chatId' => $chatId
            ));
        if($success)
        {
            if(!empty($referId))
            {
            $price = 0;
            switch($rentedMiner)
            {
                case 'TON Silver':$price = 2;
                break;
                case 'TON Gold':$price = 3;
                break;
                case 'TON Diamond':$price = 25;
                break;
                case 'TON Platinum':$price = 50;
                break;
                case 'TON VIP':$price = 100;
                break;
            }
            $percent = 25;
            $commission = $price * $percent/100;
            $query3 = "UPDATE `miningapp` SET `counter`=`miningapp`.`counter`+:counter WHERE `chatId`=:referId";
            $stmt3 = $db->prepare($query3);
            $success2 = $stmt3->execute(array(
                ':counter' => $commission,
                ':referId' => $referId
                ));
                if($success2)
                {
                    echo "miner and commission updated successfully";
                }
                    }else{
                        echo "miner updated successfully";
                }
        }
        else{
            echo "Error Updating Miner: " . implode(', ',$stmt2->errorInfo());
        }
    }
    else{
        echo "problem: " . implode(', ',$stmt1->errorInfo());
    }
}
function updateWithdrawal($chatId,$tonCoinBalance,$lastWithdrawal)
{
    global $db;
    $query1 = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
    $stmt1 = $db->prepare($query1);
    $exist = $stmt1->execute(array(
        ':chatId' => $chatId
        ));
    if($exist)
    {
        $query2 = "UPDATE `miningapp` SET `tonCoinBalance`=:tonCoinBalance,`lastWithdrawal`=:lastWithdrawal WHERE `chatId`=:chatId";
        $stmt2 = $db->prepare($query2);
        $success = $stmt2->execute(array(
            ':tonCoinBalance' => $tonCoinBalance,
            ':lastWithdrawal' => $lastWithdrawal,
            ':chatId' => $chatId
            ));
        if($success)
        {
            echo "withdrawal updated successfully";
        }
        else{
            echo "Error updating withdrawal: " . implode(', ',$stmt2->errorInfo());
        }
    }
    else{
        echo "problem: " . implode(', ',$stmt1->errorInfo());
    }
}
function CreateWithdrawal($userId,$amount,$date,$type)
{
    global $db;
    $query1 = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
    $stmt1 = $db->prepare($query1);
    $exist = $stmt1->execute(array(
        ':chatId' => $userId
        ));
    if($exist)
    {
        $query2 = "INSERT INTO `withdrawals` (`id`,`userId`,`amount`,`date`,`type`) VALUES (NULL,:userId,:amount,:date,:type)";
        $stmt2=$db->prepare($query2);
        $success = $stmt2->execute(array(
            ':userId' => $userId,
            ':amount' => $amount,
            ':date' => $date,
            ':type' => $type
            ));
        if($success)
        {
            echo "withdrawal created successfully";
        }
        else{
            echo "Error iserting withdrawal: " . implode(', ',$stmt2->errorInfo());
        }
    }
    else{
        echo "problem: " . implode(', ',$stmt1->errorInfo());
    }
}
function CreateClaims($userId,$amount,$date,$type)
{
    global $db;
    $query1 = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
    $stmt1 = $db->prepare($query1);
    $exist = $stmt1->execute(array(
        ':chatId' => $userId
        ));
    if($exist)
    {
        $query2 = "INSERT INTO `claims` (`id`,`userId`,`amount`,`date`,`type`) VALUES (NULL,:userId,:amount,:date,:type)";
        $stmt2=$db->prepare($query2);
        $success = $stmt2->execute(array(
            ':userId' => $userId,
            ':amount' => $amount,
            ':date' => $date,
            ':type' => $type
            ));
        if($success)
        {
            echo "claims chained successfully";
        }
        else{
            echo "Error iserting claims: " . implode(', ',$stmt2->errorInfo());
        }
    }
    else{
        echo "problem: " . implode(', ',$stmt1->errorInfo());
    }
}
function updateBalance($chatId, $tonCoinBalance)
{
    global $db;
    $query = "UPDATE miningapp SET tonCoinBalance = :tonCoinBalance WHERE chatId = :chatId;";
    $stmt = $db->prepare($query);
    $success = $stmt->execute([
        ':tonCoinBalance' => $tonCoinBalance,
        ':chatId' => $chatId
    ]);
    if ($success) {
        echo 'Balance updated successfully.';
    } else {
        echo 'Error updating balance: ' . implode(', ', $stmt->errorInfo());
    }
}
function updateShib($chatId, $shibCoinBalance)
{
    global $db;
    $query = "UPDATE miningapp SET shibCoinBalance = :shibCoinBalance WHERE chatId = :chatId";
    $stmt = $db->prepare($query);
    $success = $stmt->execute([
        ':shibCoinBalance' => $shibCoinBalance,
        ':chatId' => $chatId
    ]);
    if ($success) {
        echo 'Shib updated successfully.';
    } else {
        echo 'Error updating balance: ' . implode(', ', $stmt->errorInfo());
    }
}
function getClaims($userId)
{
    global $db;
    $query = "SELECT * FROM `claims` WHERE `userId`=:userId";
    $stmt = $db->prepare($query);
    $stmt->execute(array(
        ':userId' => $userId
        ));
    $user = $stmt->fetchAll(PDO::FETCH_ASSOC);
    return json_encode($user,JSON_PRETTY_PRINT) ?: null;
}
function getWithdrawals($userId)
{
    global $db;
    $query = "SELECT * FROM `withdrawals` WHERE `userId`=:userId";
    $stmt = $db->prepare($query);
    $stmt->execute(array(
        ':userId' => $userId
        ));
    $user = $stmt->fetchAll(PDO::FETCH_ASSOC);
    return json_encode($user,JSON_PRETTY_PRINT) ?: null;
}
function updateTon($chatId,$tonCoinBalance,$counter)
{
    global $db;
    $query1 = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
    $stmt1 = $db->prepare($query1);
    $exist = $stmt1->execute(array(
        ':chatId' => $chatId
        ));
    if($exist)
    {
        $query2 = "UPDATE `miningapp` SET `tonCoinBalance`=:tonCoinBalance,`counter`=:counter WHERE `chatId`=:chatId";
        $stmt2 = $db->prepare($query2);
        $success = $stmt2->execute(array(
            ':chatId' => $chatId,
            ':tonCoinBalance' => $tonCoinBalance,
            ':counter' => $counter
            ));
            if($success)
            {
                echo "updated ton coin and counter";
            }
            else{
                echo "Error updating: " .implode(', ',$stmt2->errorInfo());
            }
    }
    else{
        echo "not found user";
    }
}
function atomic_update_Shib($chatId, $shibCoinBalance, $task)
{
    global $db;

    // ابتدا بررسی می‌کنیم کاربر وجود دارد یا نه
    $stmt1 = $db->prepare("SELECT * FROM `miningapp` WHERE `chatId` = :chatId");
    $stmt1->execute([':chatId' => $chatId]);
    $userExists = $stmt1->rowCount() > 0;

    if (!$userExists) {
        echo "User not found";
        return;
    }

    // لیست تسک‌های مجاز که در دیتابیس داریم
    $validTasks = [
        'telegramJoin1', 'telegramJoin2', 'telegramJoin3', 'telegramJoin4', 'telegramJoin5',
        'twitter', 'instagram', 'youtube'
    ];

    // بررسی صحت نام تسک
    if (!in_array($task, $validTasks)) {
        echo "Invalid task";
        return;
    }

    

    // ساخت کوئری آپدیت
    $query = "
        UPDATE `miningapp` 
        SET `shibCoinBalance` = `shibCoinBalance` + :shibCoinBalance,
            `$task` = 'true'
        WHERE `chatId` = :chatId AND `$task` = ''
    ";

    $stmt2 = $db->prepare($query);
    $success = $stmt2->execute([
        ':chatId' => $chatId,
        ':shibCoinBalance' => $shibCoinBalance
    ]);

    if ($success) {
        echo "Shiba updated successfully";
    } else {
        echo "Error updating shiba: " . implode(', ', $stmt2->errorInfo());
    }
}

function atomic_update_ton($chatId,$tonCoinBalance,$task)
{
    global $db;
    $query1 = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
    $stmt1 = $db->prepare($query1);
    $exist = $stmt1->execute(array(
        ':chatId' => $chatId
        ));
    if($exist)
    {
        $query2 = "UPDATE `miningapp` SET `tonCoinBalance`=`miningapp`.`tonCoinBalance`+:tonCoinBalance";
        if($task == "invite3")
        {
            $query2=$query2.",`invite3`='true' WHERE `chatId`=:chatId and `invite3`='false'";
        }
        else if($task == "invite5")
        {
            $query2=$query2.",`invite5`='true' WHERE `chatId`=:chatId and `invite5`='false'";
        }
        else if($task == "invite10")
        {
            $query2=$query2.",`invite10`='true' WHERE `chatId`=:chatId and `invite10`='false'";
        }
        else if($task == "invite20")
        {
            $query2=$query2.",`invite20`='true' WHERE `chatId`=:chatId and `invite20`='false'";
        }
        else if($task == "invite50")
        {
            $query2=$query2.",`invite50`='true' WHERE `chatId`=:chatId and `invite50`='false'";
        }
        else{
            $query2 = "";
        }
        $stmt2 = $db->prepare($query2);
        $success = $stmt2->execute(array(
            ':chatId' => $chatId,
            ':tonCoinBalance' => $tonCoinBalance,
            ));
            if($success)
            {
                echo "ton updating succcessfully";
            }
            else{
                echo "Error updating ton: " . implode(', ',$stmt2->errorInfo());
            }
    }
    else{
        echo "not found";
    }
}
function checkChannelJoin($type)
{
    global $db;

   

    // توکن ربات
    $token = "7370600224:AAHijlGrxVPvcxk-QwuitHheg9CQcXBtA0M";
    $url = "https://api.telegram.org/bot$token/getChatMember";

    // اگر حالت 'bot' باشد همه‌ی کاربران بررسی می‌شوند
    if ($type === "bot") {
        $query = "SELECT * FROM `miningapp` WHERE 
                  (`telegramJoin1` = '' OR `telegramJoin2` = '' OR `telegramJoin3` = '' OR `telegramJoin4` = '' OR `telegramJoin5` = '')";
        $res = $db->prepare($query);
        $res->execute();

        foreach ($res as $row) {
            $chatId = $row['chatId'];

            foreach ($channelMap as $task => $channelUsername) {
                if ($row[$task] === '') {
                    $data = [
                        'chat_id' => $channelUsername,
                        'user_id' => $chatId
                    ];

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $response = curl_exec($ch);
                    curl_close($ch);

                    $response = json_decode($response, true);
                    if (isset($response['ok']) && $response['ok'] === true) {
                        $status = $response['result']['status'];
                        if (in_array($status, ['member', 'administrator', 'creator'])) {
                            // کاربر عضو کانال است، پس به‌روزرسانی کن
                            atomic_update_Shib($chatId, 0.01, $task);
                        }
                    }
                }
            }
        }
    } 
    
    // حالت بررسی یک کاربر خاص
    else {
        $chatId = $type;
        $query = "SELECT * FROM `miningapp` WHERE `chatId` = :chatId";
        $res = $db->prepare($query);
        $res->execute([':chatId' => $chatId]);
        $user = $res->fetch();

        if (!$user) {
            return false;
        }

        foreach ($channelMap as $task => $channelUsername) {
            if ($user[$task] === '') {
                $data = [
                    'chat_id' => $channelUsername,
                    'user_id' => $chatId
                ];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $response = curl_exec($ch);
                curl_close($ch);

                $response = json_decode($response, true);
                if (isset($response['ok']) && $response['ok'] === true) {
                    $status = $response['result']['status'];
                    if (in_array($status, ['member', 'administrator', 'creator'])) {
                        return $task; // برگشت نام تسک
                    }
                }
            }
        }

        return false; // اگر هیچ کانالی عضو نبود
    }
}

?>