<?php
include_once 'connect.php';
global $db;
require '../vendor/autoload.php';

use GuzzleHttp\Client;

$token = "7501208583:AAHxEf5lifWjJQ0r4tOK9YoE_-T73g8UdTs";
$botUrl = "https://api.telegram.org/bot$token/";
function sendPhoto($chatId, $photoPath, $caption, $keyboard) {
    global $botUrl;

    $client = new Client();
    try {
        $response = $client->post("{$botUrl}sendPhoto", [
            'multipart' => [
                [
                    'name' => 'chat_id',
                    'contents' => $chatId
                ],
                [
                    'name' => 'photo',
                    'contents' => fopen($photoPath, 'r')
                ],
                [
                    'name' => 'caption',
                    'contents' => $caption,
                ],
                [
                    'name' => 'reply_markup',
                    'contents' => json_encode($keyboard)
                ],
                [
                    'name' => 'parse_mode',
                    'contents' => 'HTML'
                ]
            ],
        ]);
        return json_decode($response->getBody(), true);
    } catch (Exception $e) {
        error_log("Error sending photo: " . $e->getMessage());
    }
}

function postData($data) {
    $apiUrl = 'https://tonswap.online/bot/api.php';
    $client = new Client();
    try {
        $response = $client->post($apiUrl, [
            'form_params' => $data
        ]);
        return json_decode($response->getBody(), true);
    } catch (Exception $e) {
        error_log("Error posting data: " . $e->getMessage());
        return null;
    }
}

function handleStartCommand($chatId, $userName, $referrerId) {
    $data = [
        'func' => 'getUser',
        'chatId' => $chatId
    ];

    $response = postData($data);
    
    if ($response !== null) {
        $userExists = $response;

        if (!$userExists) {
            $newUser = [
                'chatId' => $chatId,
                'userName' => $userName,
                'tonCoinBalance' => 0,
                'shibCoinBalance' => 0,
                'counter' => 0,
                'referral_link' => "https://t.me/Tonkeeperhub_bot?start={$chatId}",
                'referrerId' => $referrerId || null,
                'registrationDate' => date('c')
            ];

            postData(["func" => "create_user"] + $newUser);

            if ($referrerId) {
                $referrerData = [
                    'func' => 'updateReferId',
                    'chatId' => $chatId,
                    'referrerId' => $referrerId
                ];
                postData($referrerData);
            }
        }
        else{
            global $db;
            $query_check = "SELECT * FROM `miningapp` WHERE `chatId`=:chatId";
            $stmt = $db->prepare($query_check);
            $stmt->execute(array(
                ':chatId' => $chatId
                ));
            $referId;
            foreach($stmt as $row)
            {
                $referId = $row['referId'];
                if(empty($referId) and $referrerId)
                {
                    $referrerData = [
                        'func' => 'updateReferId',
                        'chatId' => $chatId,
                        'referrerId' => $referrerId
                    ];
                    postData($referrerData);
                }
            }
        }

        $photoPath = 'https://tonswap.online/bot/assets/tonkeeper.jpg';
        $message = "Hello $userName! Welcome\n\nEarn TON 💎   by staking (Only TON Network for holders) \n🌐 📣 <a href=\"https://ton.org/\">Website</a>  | 📣 <a href=\"https://t.me/toncoin\">Channel</a> | 💭 <a href=\"https://t.me/tonnel_chat\">Chat</a> | 🕊 <a href=\"https://x.com/ton_blockchain\">Twitter</a>";
        $keyboard = [
            'inline_keyboard' => [
                [['text' => 'Join Community 🧑‍💻', 'url' => 'https://t.me/toncoin']],
                [['text' => 'TON Boost', 'web_app' => ['url' => 'https://tonswap.online/']]]
            ]
        ];
        sendPhoto($chatId, $photoPath, $message, $keyboard);
    }
}

$update = json_decode(file_get_contents('php://input'), true);
if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $userName = $message['from']['first_name'];
    $text = $message['text'] ?? '';

    if (strpos($text, '/start') === 0) {
        if(strlen(substr($text,7))>0)
        {
            $referrerId = substr($message['text'],7) ?? null;
        }
        if(empty($referrerId) or $referrerId==$chatId)
        $referrerId = null;
        //$referrerId = explode(' ', $text)[1] ?? null;
        handleStartCommand($chatId, $userName, $referrerId);
    }
}

?>