<?php
    use Firebase\JWT\JWT;
    use Firebase\JWT\Key;

    require 'assets/plugins/php-jwt-main/src/JWT.php';
    require 'assets/plugins/php-jwt-main/src/Key.php';
    require_once 'includes/jdf.php';
    require_once 'api/Crypto.php';

   function insert($table, $data) {
        include 'includes/config.php';
        $fields = array_keys( $data );  
        $values = array_map(array($connect, 'real_escape_string'), array_values($data) );
        
        $sql = "INSERT INTO $table (".implode(",",$fields).") VALUES ('".implode("','", $values )."')";
        mysqli_query($connect, $sql);
    }

function SQLiSelect($table, $condition) {
    include 'includes/config.php';

    if (!$connect) {
        die("No database connection.");
    }

    $query = "SELECT * FROM $table $condition";
    $result = $connect->query($query);

    if (!$result) {
        die("Query failed: " . $connect->error);
    }

    return $result;
}


    function delete($table_name, $where_clause = '') {
        include 'includes/config.php';
        $whereSQL = '';
        if(!empty($where_clause)) {
            if(substr(strtoupper(trim($where_clause)), 0, 5) != 'WHERE') {
                $whereSQL = " WHERE ".$where_clause;
            } else {
                $whereSQL = " ".trim($where_clause);
            }
        }
        $sql = "DELETE FROM ".$table_name.$whereSQL;
        return mysqli_query($connect, $sql);

    }

    // Update Data, Where clause is left optional
    function update($table_name, $form_data, $where_clause = '') {

        include 'includes/config.php';
        // check for optional where clause
        $whereSQL = '';
        if(!empty($where_clause)) {
            // check to see if the 'where' keyword exists
            if(substr(strtoupper(trim($where_clause)), 0, 5) != 'WHERE') {
                // not found, add key word
                $whereSQL = " WHERE ".$where_clause;
            } else {
                $whereSQL = " ".trim($where_clause);
            }
        }
        // start the actual SQL statement
        $sql = "UPDATE ".$table_name." SET ";

        // loop and build the column /
        $sets = array();
        foreach($form_data as $column => $value) {
             $sets[] = "`".$column."` = '".$value."'";
        }
        $sql .= implode(', ', $sets);

        // append the where statement
        $sql .= $whereSQL;
             
        // run and return the query result
        return mysqli_query($connect, $sql);
    }

    function clean($data) {
        include 'includes/config.php';
        $data = mysqli_real_escape_string($connect, $data);
        return $data; 
    }


function SetProperties($Key, $value)
{
    if (mysqli_num_rows(SQLiSelect("tbl_properties", "WHERE Key_Name= '" . $Key . "' ")) > 0) {
        $Data = array(
            'Key_Value' => $value
        );
        update("tbl_properties", $Data, "WHERE Key_Name='" . $Key . "'");
    } else {
        $Data = array(
            'Key_Name' => $Key,
            'Key_Value' => $value,
            'LastChange' => time()
        );
        SQLiInsert("tbl_properties", $Data);
    }
}
    function GetProperties($Key)
    {
        $Key_Result = SQLiSelect("tbl_properties", "WHERE Key_Name= '" . $Key . "' ");
        if (mysqli_num_rows($Key_Result) > 0) {
            return mysqli_fetch_assoc($Key_Result)['Key_Value'];
        } else {
            return "CANT_FIND_KEY";
        }
    }



    function check_exist_user($username)
    {
        $sql_querry = SQLiSelect('tbl_users', "WHERE username='" . $username . "'");
        return mysqli_num_rows($sql_querry);
    }

    function check_exist_validate($username, $password)
    {
        $sql_querry = SQLiSelect('tbl_users', "WHERE username='" . $username . "' AND userpass='" . $password . "'");
        return mysqli_num_rows($sql_querry);
    }

    function active_user($username, $password)
    {
        $sql_querry = SQLiSelect('tbl_users', "WHERE username='" . $username . "' AND userpass='" . $password . "'");
        return mysqli_fetch_array($sql_querry)['userstatus'];
    }

    function is_valid_device($username, $password, $device_id)
    {
        $sql_querry_all = SQLiSelect('tbl_users', "WHERE username='" . $username . "' AND userpass='" . $password . "'");
        $sql_querry_fetch = mysqli_fetch_assoc($sql_querry_all);

        if (mysqli_num_rows($sql_querry_all) > 0) {
            if ($sql_querry_fetch['deviceid'] == null) {
                $Data = array(
                    'deviceid' => $device_id,
                );
                update("tbl_users", $Data, "WHERE username='" . $username . "' AND userpass='" . $password . "'");
            }
        }
        $sql_querry = SQLiSelect('tbl_users', "WHERE username='" . $username . "' AND userpass='" . $password . "' AND (deviceid='" . $device_id . "' OR deviceid='free')");
        return mysqli_num_rows($sql_querry);
    }







    function getAccountArray($username)
    {
        $Key_Result = SQLiSelect("tbl_users", "WHERE username= '" . $username . "' AND userstatus='true' ");
        if (mysqli_num_rows($Key_Result) > 0) {


                    $users_ = mysqli_fetch_assoc($Key_Result);
                    $users = array(
                        'username' => $users_['username'],
                        'created' => date("Y/m/d", $users_['created']),
                        'ended' => date("Y/m/d", $users_['ended']),
                        'accoutstatus' => $users_['userstatus'],
                        'deviceid' => $users_['deviceid'],
                        'status' => 'success',
                        'code' => '0'
                    );
                    $servers[] = $users;



        } else {
            $server = array(
                'status' => 'error',
                'code' => '1'
            );
            $servers[] = $server;
        }


        return $servers;
    }
function getServerArray($username)
{
    $Key_Result = SQLiSelect("tbl_users", "WHERE username= '" . $username . "' AND userstatus='true' ");
    $Key_Result_Server = SQLiSelect("tbl_servers", "WHERE server_status='true'");
    if (mysqli_num_rows($Key_Result) > 0) {


        while ($users_ = mysqli_fetch_array($Key_Result_Server)) {
            $users = array(
                'server' => EncryptThis($users_['server'])
            );
            $servers[] = $users;
        }


    } else {
        $server = array(
            'status' => 'error',
            'code' => '1'
        );
        $servers[] = $server;
    }


    return $servers;
}

function getServer($username, $password, $device_id)
{
    if (check_exist_user($username) > 0) {
        if (check_exist_validate($username, $password)) {
            if (active_user($username, $password) == 'true') {
                if (is_valid_device($username, $password, $device_id)) {
                    $server_data = mysqli_fetch_assoc(SQLiSelect("tbl_users", " WHERE username= '" . $username . "' "));
                    $check_date = $server_data['ended'] / 86400 - (time() / 86400);
                    if ($check_date <= 0) {
                        $Response = array("status" => 'مدت زمان اشتراک شما به پایان رسیده است', 'code' => '1');
                        $Data = array(
                            'userstatus' => 'false'
                        );
                        update("tbl_users", $Data,"WHERE username='".$username."'");
                        $Response = array(
                            'status' => 'حساب کاری به دلیل اتمام اشتراک غیر فعال شد',
                            'code' => '1'
                        );

                    } else {
                        $Response = array(
                            'Serverdata' => getServerArray($username),
                            'status' => 'دریافت موفقیت آمیز بود',
                            'code' => '0'
                        );
                    }
                } else {
                    $Response = array("status" => 'حساب کاربری وارد شده متعلق به یک گوشی دیگر میباشد', 'code' => '1');
                }
            } else {
                $Response = array("status" => 'حساب کاربری شما غیر فعال است', 'code' => '1');
            }
        } else {
            $Response = array("status" => 'گذر واژه نادرست است', 'code' => '1');
        }
    } else {
        $Response = array("status" => 'کاربری با این نام کاربری یافت نشد', 'code' => '1');
    }

    return $Response;
}


    function getAccount($username, $password, $device_id)
    {
            if (check_exist_user($username) > 0) {
                if (check_exist_validate($username, $password)) {
                    if (active_user($username, $password) == 'true') {
                        if (is_valid_device($username, $password, $device_id)) {
                            $server_data = mysqli_fetch_assoc(SQLiSelect("tbl_users", " WHERE username= '" . $username . "' "));
                            $check_date = $server_data['ended'] / 86400 - (time() / 86400);
                            if ($check_date <= 0) {
                                $Response = array("status" => 'مدت زمان اشتراک شما به پایان رسیده است', 'code' => '1');
                                $Data = array(
                                    'userstatus' => 'false'
                                );
                                update("tbl_users", $Data,"WHERE username='".$username."'");
                                $Response = array(
                                    'status' => 'حساب کاری به دلیل اتمام اشتراک غیر فعال شد',
                                    'code' => '1'
                                );

                            } else {
                                $Response = array(
//                                    'serverdata' => getServerArray($username),
                                    'Accountdata' => getAccountArray($username),
                                    'status' => 'ورود موفقیت آمیز بود',
                                    'code' => '0'
                                );
                            }
                        } else {
                            $Response = array("status" => 'حساب کاربری وارد شده متعلق به یک گوشی دیگر میباشد', 'code' => '1');
                        }
                    } else {
                        $Response = array("status" => 'حساب کاربری شما غیر فعال است', 'code' => '1');
                    }
                } else {
                    $Response = array("status" => 'گذر واژه نادرست است', 'code' => '1');
                }
            } else {
                $Response = array("status" => 'کاربری با این نام کاربری یافت نشد', 'code' => '1');
            }

        return $Response;
    }
    function getAccountTime($device_id)
    {
        $server_q = mysqli_fetch_assoc(SQLiSelect("tbl_device_id","WHERE device_id='".$device_id."'"));
        $current_time_minutes = time();
        $saved_time_minutes = ($server_q['start_time']);
        $check_date = $current_time_minutes - $saved_time_minutes;
        return array('time' => round($server_q['time'] * 60), 'time_' => round($check_date));
    }
    function getUserAccoutArray($username)
    {
        $Key_Result = SQLiSelect("tbl_users", "WHERE vpn_username= '" . $username . "' AND status='true'");
        if (mysqli_num_rows($Key_Result) > 0) {
            $servers = array();
            while ($server_data = mysqli_fetch_assoc($Key_Result)) {
                $server = array(
                    'email' => EncryptThis($server_data['email']),
                    'vpn_username' => EncryptThis($server_data['vpn_username']),
                    'create_date' => EncryptThis(date(" Y/m/d", $server_data['create_date'])),
                    'end_date' => EncryptThis(date(" Y/m/d", $server_data['end_date'])),
                    'days_count' => EncryptThis(round(($server_data['end_date'] / 86400) - (time() / 86400)))
                );
                $servers[] = $server;
            }
        } else {
            $server = array(
                'status' => 'error',
                'code' => '1'
            );
            $servers[] = $server;
        }


        return $servers;
    }


function generateRandomPassword($length) {
    $characters = '0123456789';
    $password = '';

    for ($i = 0; $i < $length; $i++) {
        $password .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $password;
}
function generateRandomUsername($length) {
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $username = '';
    for ($i = 0; $i < $length; $i++) {
        $username .= $characters[rand(0, strlen($characters) - 1)];
    }
    return ucfirst(strtolower($username));  // Capitalize the first letter
}
//echo json_encode(getServerArray("test"),JSON_PRETTY_PRINT);

?>